/**********
* File: CDGL_IDirect3DVolume9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DVolume9. 
					 This class is our concrete implementation of IDirect3DVolume9 interface in Direct3D9. The class IDirect3DVolume9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 17Mar05

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DVOLUME9_H__
#define __CDGL_IDIRECT3DVOLUME9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

#ifndef LIB_CHANGES
#include "OZone/ITexture.h"
#else
#include "ITexture.h"
#endif	// LIB_CHANGES

class CDGL_IDirect3DVolume9 : public IDirect3DVolume9
{
	public:
		
		CDGL_IDirect3DVolume9(IDirect3DDevice9 *in_pDevice);
		CDGL_IDirect3DVolume9(IDirect3DDevice9 *in_pDevice, D3DVOLUME_DESC volumeDesc, ITexture , UINT level);
	
		~CDGL_IDirect3DVolume9();
		
		/*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		/*** IDirect3DVolume9 methods ***/
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT SetPrivateData( REFGUID refguid,CONST void* pData,DWORD SizeOfData,DWORD Flags);
		HRESULT GetPrivateData( REFGUID refguid,void* pData,DWORD* pSizeOfData);
		HRESULT FreePrivateData( REFGUID refguid);
		HRESULT GetContainer( REFIID riid,void** ppContainer);
		HRESULT GetDesc( D3DVOLUME_DESC *pDesc);
		HRESULT LockBox( D3DLOCKED_BOX * pLockedVolume,CONST D3DBOX* pBox,DWORD Flags);
		HRESULT UnlockBox();

	
	
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• Additional methods •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|

		// Gives back the pointer to the local image of a level.
		void*					GetLocalImage() { return m_pLocalImage; }
	
		// Sets the local image of a mip level
		void					SetLocalImage(void *in_pData) { m_pLocalImage = in_pData; }
	
	private:
		//! Member Variables
		int						m_lRefCount;
		IDirect3DDevice9 *		m_pDevice; //Shilpa - not sure if this is required - check this.	
		D3DVOLUME_DESC			mVolumeDesc;
	
	
		void					*m_pLocalImage; 
		ITexture				mTexture;
		UINT					mLevel;
};


#endif //__CDGL_IDIRECT3DVOLUME9_H__

